# BlockPooky ESO Addon Development Guide

## Project Overview
BlockPooky is an Elder Scrolls Online (ESO) addon that warns players about incoming abilities that require blocking, particularly in PvP scenarios. Originally inspired by rumors about a "BLOCK" warning addon for ballgroup encounters, BlockPooky has evolved into a comprehensive PvP awareness tool.

### Core Features
- **Block Warnings**: Visual/audio alerts for incoming pull abilities (DC/ROA/chains/etc.)
- **Block Detection**: Shows when player is actively blocking (addresses "Am I Blocking?" uncertainty)
- **Ready Hints**: Notifications when Dark Convergence/Rush of Agony cooldowns expire
- **Vigor Timing**: Optimal Vigor recasting reminders (8s intervals for group play)
- **CC Immunity Bar**: Tracks immunity duration from dodge rolls/potions
- **Negate Warnings**: Alerts when standing in enemy Negate Magic fields
- **Custom Cooldown Bars**: User-configurable tracking for any ability/effect
- **Group Integration**: Cross-addon compatibility with Agony Warning via map ping encoding

The addon provides multiple notification channels: movable UI frames, Center Screen Announcements (CSA), audio alerts, chat messages, and group notifications.

## Architecture & File Structure

### Core Module Pattern
All files follow the ESO addon pattern: `BlockPooky = BlockPooky or {}` followed by `local BlockPooky = BlockPooky` for performance. Each module extends the global table with specific functionality.

### Module Responsibilities
File loading order (as defined in `BlockPooky.txt`):
- `BlockPooky_ccbar.lua` - CC immunity tracking with unstoppable items/skills
- `BlockPooky_blocking.lua` - Block detection and blocking indicator UI  
- `BlockPooky_hints.lua` - Timing hints for DC/ROA abilities and vigor recasting
- `BlockPooky_cooldowns.lua` - Custom cooldown bars for abilities/effects
- `BlockPooky_negate.lua` - Negate Magic field detection and warnings
- `BlockPooky.lua` - Main initialization, event handling, and combat event processing
- `BlockPooky_menue.lua` - LibAddonMenu integration for settings UI (loads after main)
- `BlockPooky.xml` - UI control definitions with movable indicators

**Note**: Module loading order matters - main `BlockPooky.lua` loads after feature modules to ensure all components are available during initialization.

## Key Dependencies
Required libraries (specified in `BlockPooky.txt`):
- **LibChatMessage** - Chat output with tags ("BP") for formatted addon messages (located at `..\LibChatMessage`)
- **LibAddonMenu-2.0** - Settings menu system for in-game configuration UI (located at `..\LibAddonMenu-2.0`)
- **LibMapPing** - Map ping manipulation for cross-addon group communication (located at `..\LibMapPing`)
- **LibGPS** - GPS coordinate system for map ping encoding/decoding (located at `..\LibGPS`)
- **ZO_SavedVars** - Configuration persistence (account-wide + per-character)

The addon uses `## DependsOn:` declaration to ensure these libraries load before BlockPooky initializes. Libraries are typically installed as separate addons in the parent AddOns directory.

## Critical Patterns

### Event Registration Pattern
```lua
EVENT_MANAGER:RegisterForEvent(self.name .. "Suffix", EVENT_TYPE, function(...) self:HandlerMethod(...) end)
EVENT_MANAGER:AddFilterForEvent(self.name .. "Suffix", EVENT_TYPE, REGISTER_FILTER_UNIT_TAG, "player")
```

### UI Control Creation Pattern
```lua
local control = CreateControl(self.name.."ControlName", parent, CT_TOPLEVELCONTROL)
control:SetMovable(true)
control:SetMouseEnabled(true)
control:SetHandler("OnMoveStop", function() self:SavePositionMethod() end)
```


### Ability & Effect Detection Logic
Block warnings and CC immunity detection use:
- `EVENT_COMBAT_EVENT` with `ACTION_RESULT_EFFECT_GAINED` for ability triggers
- `EVENT_EFFECT_CHANGED` for effect-based detection
- **Potion consumption detection now uses `EVENT_INVENTORY_SINGLE_SLOT_UPDATE` (OnSlotUpdate) as a primary, working method.**
	- This event reliably detects when a player consumes an immunity potion from the backpack.
	- No longer considered a fallback; update code comments and workflows accordingly.
1. Check if ability/effect matches configured triggers
2. Verify source is not player/companion/group member
3. Apply cooldown to prevent spam
4. Trigger warning via multiple channels (UI/sound/chat)

### Configuration Structure
- Account-wide settings in `self.config` (trigger abilities, UI colors, positions)
- Character-specific settings in `self.toonConfig` (cooldown bar visibility)
- Position saving pattern: `GetLeft()`/`GetTop()` → save to config → restore via `SetAnchor(TOPLEFT, ...)`

## Development Workflows

### Adding New Warning Types
1. Create new ability ID arrays (like `predefinedTriggerAbilities`)
2. Add event registration in `Initialize()`
3. Create UI controls in corresponding module
4. Add menu options in `BlockPooky_menue.lua`
5. Handle position saving/loading for movable elements

### Finding Ability/Effect IDs
1. Open addon menu with `/blockpooky` command
2. Enable "Investigate Abilities" or "Investigate Effects" under Debug Tools
3. Trigger the ability/effect in-game to see ID in chat
4. Format: `Effect? Name: <name> | ID: <id> | BT: <beginTime> | ET: <endTime>`
5. Remember to disable investigation to prevent chat spam

### Testing Features
- Use `/blockpookytest` command to trigger test warning
- Enable debug tools for real-time ability/effect monitoring
- Group messaging testing requires being in a group with compatible addons

### UI Customization
All UI elements support:
- Color customization via `SetColor(unpack(config.colorArray))`
- Position persistence with `Save*Position()` and `Load*Position()` methods
- Lock/unlock mode via `config.lockedUI` for positioning
- Font size configuration through `setBlockPookyFont()` method
- Movable frames with mouse interaction handlers

### Custom Cooldown Bars
- Support both "ability" and "effect" types
- Effects use begin/end times from events, abilities use configured cooldown durations
- Character-specific visibility settings in `toonConfig.cooldownbar`
- Account-wide configuration (position, colors, IDs) in `config.cooldownbar`
- Dynamic creation/removal through settings menu

## ESO-Specific Conventions
- Use `GetAbilityName(id)` with `CleanupName()` to handle client language differences
- Combat state detection via `IsUnitInCombat("player")`
- Group detection patterns: `IsUnitGrouped("player")` + `GetGroupUnitTagByIndex()`
- Map ping encoding for cross-group communication using coordinate manipulation
- Font creation: `CreateFont()` with ESO font constants like `$(BOLD_FONT)`

## Integration Points
- **LibMapPing callbacks** for group messaging via encoded pings
- **ZO_CallbackObject** for internal state change notifications
- **CENTER_SCREEN_ANNOUNCE** for CSA messages with configurable lifespans
- **SavedVariables** with version management (`svVersion`) for config migration