# BlockPooky - ESO Addon


[![ESO API Version](https://img.shields.io/badge/ESO%20API-101046-blue)](https://www.esoui.com/)
[![Version](https://img.shields.io/badge/Version-2.4-green)](https://github.com/your-repo/BlockPooky)

> **Warns the Pooky if blocking is necessary** - A comprehensive PvP awareness addon for Elder Scrolls Online

## Overview

BlockPooky is an Elder Scrolls Online addon that provides critical combat awareness for PvP scenarios. Originally inspired by rumors about ballgroup "BLOCK" warning addons, it has evolved into a comprehensive tool that helps players react to incoming threats and optimize their defensive gameplay.

## Features

### 🛡️ Block Warnings
- **Visual Alerts**: Large, customizable UI frame with "BLOCK Pooky!" message
- **Audio Notifications**: Configurable sound alerts (Duel Start sound)
- **Center Screen Announcements (CSA)**: BA-style messages for critical awareness
- **Chat Integration**: Optional chat warnings with addon tags
- **Group Messaging**: Cross-addon compatibility with Agony Warning

### 🎯 Smart Detection
- **Ability Recognition**: Detects incoming pull abilities (Dark Convergence, Rush of Agony, chains, etc.)
- **Group Awareness**: Ignores abilities from group members and companions
- **Custom Triggers**: Add your own ability IDs for personalized detection
- **Language Support**: Works across different ESO client languages

### 📊 Combat Awareness
- **Block Detection**: Shows when you're actively blocking (solves "Am I Blocking?" uncertainty)
- **CC Immunity Tracking**: Visual bar showing immunity duration from dodge rolls/potions/poisons
- **Negate Warnings**: Alerts when standing in enemy Negate Magic fields
- **Ready Hints**: Notifications when DC/ROA abilities are off cooldown

### ⚡ Performance Tools
- **Vigor Timing**: Optimal recasting reminders (8s intervals for group play)
- **Custom Cooldown Bars**: Track any ability or effect with personalized bars
- **Mount Notifications**: Reminds you when it's safe to mount in Cyrodiil


### 🎨 Customization & Combat Visuals
- **Movable UI**: Drag and position all elements anywhere on screen
- **Color Themes**: Customize colors for all UI components
- **Font Sizing**: Adjustable font sizes for visibility
- **Duration Controls**: Configure how long messages stay visible
- **Combat Visuals UI**: Adjust maximum AOE brightness, outline thickness, and target outline intensity from the settings menu
- **RGB AOE Cycling**: Enable color cycling for AOE indicators (with speed and turbo controls)

## Installation

1. Download and install the required dependencies:
   - [LibChatMessage](https://www.esoui.com/downloads/info2382-LibChatMessage.html)
   - [LibAddonMenu-2.0](https://www.esoui.com/downloads/info7-LibAddonMenu.html)
   - [LibMapPing](https://www.esoui.com/downloads/info1302-LibMapPing.html)
   - [LibGPS](https://www.esoui.com/downloads/info1037-LibGps.html)

2. Extract BlockPooky to your ESO AddOns folder:
   ```
   Documents\Elder Scrolls Online\live\AddOns\BlockPooky\
   ```

3. Launch ESO and enable the addon in the Add-ons menu

## Quick Start

1. **Open Settings**: Type `/blockpooky` in chat or access via ESO Settings > Add-ons
2. **Configure Triggers**: Select which abilities should trigger block warnings
3. **Customize UI**: Set colors, positions, and notification preferences
4. **Test Setup**: Use `/blockpookytest` to verify everything works

## Configuration

### Basic Settings
- **Show CSA**: Enable Center Screen Announcements
- **Play Sound**: Audio alerts for block warnings
- **Show UI Frame**: Large visual warning message
- **Chat Warnings**: Text notifications in chat
- **Group Messaging**: Send "They pulled me!" messages to group


### Advanced Features
- **Custom Triggers**: Add ability IDs for personalized detection
- **Cooldown Bars**: Create bars for any ability or effect
- **Combat Visuals**: UI controls for AOE brightness, outline thickness, target outline intensity, and RGB AOE cycling
- **Debug Tools**: Investigate ability/effect IDs in real-time
- **UI Positioning**: Lock/unlock mode for moving interface elements

## Usage Tips

### Finding Ability IDs
1. Enable "Investigate Abilities" or "Investigate Effects" in Debug Tools
2. Trigger the ability/effect in-game
3. Check chat for the ID (format: `Effect? Name: <name> | ID: <id>`)
4. Disable investigation to prevent chat spam

### Optimal Vigor Usage
- Enable Vigor hints for group play optimization
- "Vigor!" appears after 8 seconds
- Starts blinking at 16 seconds if not recast
- Essential for maintaining group healing efficiency

### Group Coordination
- Works with Agony Warning addon for cross-addon communication
- Uses encoded map pings for group messaging
- Filters pulls to send only ROA/DC warnings (configurable)

## Development

### Project Structure
```
BlockPooky/
├── BlockPooky.lua          # Main initialization and event handling
├── BlockPooky_blocking.lua # Block detection system
├── BlockPooky_ccbar.lua    # CC immunity tracking
├── BlockPooky_cooldowns.lua# Custom cooldown bars
├── BlockPooky_hints.lua    # Timing hints and notifications
├── BlockPooky_negate.lua   # Negate field detection
├── BlockPooky_menue.lua    # Settings UI integration
├── BlockPooky.xml          # UI control definitions
└── BlockPooky.txt          # Addon manifest
```

### Dependencies Location
All libraries should be installed as separate addons:
```
AddOns/
├── BlockPooky/
├── LibChatMessage/
├── LibAddonMenu-2.0/
├── LibMapPing/
└── LibGPS/
```

### Key Patterns
- Module pattern: `BlockPooky = BlockPooky or {}`
- Event registration with proper filtering
- UI controls with position persistence
- Account-wide and character-specific settings

## Commands

- `/blockpooky` - Open addon settings menu
- `/blockpookytest` - Trigger test warning

## Compatibility

- **ESO API Version**: 101046
- **Compatible Addons**: Agony Warning (cross-addon messaging)
- **Languages**: All ESO client languages supported
- **Platforms**: PC/Mac

## Support

For issues, feature requests, or questions:
- Check the [wiki documentation](https://wiki.claudiapps.de/wiki:blockpooky)
- Review the `.github/copilot-instructions.md` for development guidance

## License

This addon is released under standard ESO addon terms. See individual library licenses for dependencies.


## Changelog


### Version 2.4
- Added Combat Visuals submenu: UI controls for AOE brightness, outline thickness, and target outline intensity
- Added RGB AOE cycling: Enable/disable, speed, turbo, and default color controls
- Improved settings persistence and menu integration
- Updated CC immunity bar logic for new ESO API (Escapist's Poison supported)
- Compatible with latest ESO API (101046)

### Version 2.2
- Full feature set as documented
- Compatible with latest ESO API

---

**Remember**: In PvP, awareness is survival. BlockPooky helps you stay one step ahead! 🛡️