--[[ basic initialization -------------------------------------------------------------------------------------------]]
BlockPooky = BlockPooky or {}
local BlockPooky = BlockPooky

BlockPooky.lastDcCast = 0
BlockPooky.lastRoaCast = 0
BlockPooky.lastVigorCast = 0

--[[ hints implementation -------------------------------------------------------------------------------------------]]

function BlockPooky:DcReadyHint(gameTimeMs)
    if self.config.dcHint then
        if self.lastDcCast ~=0 and gameTimeMs - self.lastDcCast > 25000 then
            self.lastDcCast = 0
            BlockPooky:MessageThePooky(self.config.messages.dcReady)
        end
    end
end

function BlockPooky:RoaReadyHint(gameTimeMs)
    if self.config.roaHint then
        if self.lastRoaCast ~=0 and gameTimeMs - self.lastRoaCast > 8000 then
            self.lastRoaCast = 0
            BlockPooky:MessageThePooky(self.config.messages.roaReady)
        end
    end
end

local vigorHint_active=false
function BlockPooky:UpdateCastVigorHint(gameTimeMs)
    if self.config.vigorHint then
        if self.lastVigorCast ~=0 then
            local lastCastTimeMs = gameTimeMs - self.lastVigorCast
            if vigorHint_active then
                if lastCastTimeMs > 20000 then
                    vigorHint_active = false
                    VigorIndicator:SetHidden(not self.config.lockedUI)
                    self.lastVigorCast = 0
                elseif lastCastTimeMs > 12000 then
                    vigorHint_active = false
                    VigorIndicator:SetHidden(not self.config.lockedUI)
                end
            else
                if lastCastTimeMs >= 16000 then
                    vigorHint_active = true
                    VigorIndicator:SetHidden(false)
                elseif lastCastTimeMs >= 8000 then
                    vigorHint_active = true
                    VigorIndicator:SetHidden(false)
                end
            end
        elseif vigorHint_active then
            vigorHint_active = false
            VigorIndicator:SetHidden(not self.config.lockedUI)
        end
    elseif vigorHint_active then
        vigorHint_active = false
        VigorIndicator:SetHidden(not self.config.lockedUI)
    end
end

function BlockPooky:OnVigorIndicatorMoveStop()
    BlockPooky.config.vigorUI.left = VigorIndicator:GetLeft()
    BlockPooky.config.vigorUI.top = VigorIndicator:GetTop()
end

function BlockPooky:ResetHintsPosition()
    if VigorIndicator:GetAnchor() ~= nil then
        VigorIndicator:ClearAnchors()
    end
    VigorIndicator:SetAnchor(BOTTOM, GuiRoot, CENTER, 0, 0)
    self:OnVigorIndicatorMoveStop()
end

function BlockPooky:RestoreHintsPosition()
    -- vigorHint
    left = self.config.vigorUI.left
    top = self.config.vigorUI.top
    if (left ~= nil and top ~= nil and left > 0 and top > 0) then
        if VigorIndicator:GetAnchor() ~= nil then
            VigorIndicator:ClearAnchors()
        end
        VigorIndicator:SetAnchor(TOPLEFT, GuiRoot, TOPLEFT, left, top)
    else
        self:ResetHintsPosition()
    end
end

function BlockPooky:SetVigorHintColor()
    if self.config.vigorUI.color~=nil then
        VigorIndicatorLabel:SetColor(unpack(self.config.vigorUI.color))
    end
end