--[[ basic initialization -------------------------------------------------------------------------------------------]]
BlockPooky = BlockPooky or {}
local BlockPooky = BlockPooky

BlockPooky.negateWarningLabel = nil
local BlockPooky_negateWarningActive = false

-- Fähigkeit-IDs für "Negate Magic" und Morphs
BlockPooky.NEGATE_IDS = {
    27706, -- Negate Magic
    28341, -- Suppression Field (Morph)
    28348, -- Absorption Field (Morph)
}
BlockPooky.NEGATE_NAMES = nil


--[[ negate warning implementation ----------------------------------------------------------------------------------]]

function BlockPooky:SetNegateWarningColor()
    if self.config.negate then
        self.negateWarningLabel:SetColor(unpack(self.config.negate.color))
    else
        self.negateWarningLabel:SetColor(1, 0, 0, 1)
    end
end

function BlockPooky:SaveNegateWarningPosition()
    local left, top = self.negateWarning:GetLeft(), self.negateWarning:GetTop()
    self.config.negate.left = left
    self.config.negate.top = top
end

function BlockPooky:LoadNegateWarningPosition()
    if self.negateWarning then
        if self.config and self.config.negate then
            if self.negateWarning:GetAnchor() ~= nil then
                self.negateWarning:ClearAnchors()
            end
            self.negateWarning:SetAnchor(TOPLEFT, GuiRoot, TOPLEFT, self.config.negate.left, self.config.negate.top)
        else
            self:ResetNegateWarningPosition()
        end
    end
end

function BlockPooky:InitNegateWarning()
end

function BlockPooky:CreateNegateWarningLabel() 
    if BlockPooky.negateWarning == nil then
        --d("CREATE negateWarningLabel")
        self.negateWarning = CreateControl(self.name.."NegateWarning", GuiRoot, CT_TOPLEVELCONTROL)
        local control = BlockPooky.negateWarning
        control:SetDimensions(350, 30)
        control:SetAnchor(CENTER, GuiRoot, CENTER, 0, -120)
        control:SetMovable(true) -- Verschiebbar machen
        control:SetMouseEnabled(true) -- Mausinteraktionen erlauben
        control:SetHidden(true)
        self.negateWarningLabel = CreateControl(self.name.."NegateWarningLabel", control, CT_LABEL)
        local label = self.negateWarningLabel
        label:SetFont("BlockPookyBigFont")
        label:SetText(self.config.messages.negateWarning)
        self.negateWarningLabel:SetHorizontalAlignment(TEXT_ALIGN_CENTER)
        self.negateWarningLabel:SetAnchor(TOP, self.negateWarning, TOP, 0, 0)
        BlockPooky_negateWarningActive = false
        self:SetNegateWarningColor()
        self.negateWarning:SetHandler("OnMoveStop", function()
            self:SaveNegateWarningPosition()
        end)
        self:LoadNegateWarningPosition()
    end
end

function BlockPooky:HideNegateWarning()
    if BlockPooky_negateWarningActive and BlockPooky.negateWarning then
        BlockPooky.negateWarning:SetHidden(true)
    end
end

function BlockPooky:ShowNegateWarning()
    if not BlockPooky_negateWarningActive then
        BlockPooky.negateWarning:SetHidden(false)
        BlockPooky_negateWarningActive = true
    end
    zo_callLater(function() BlockPooky:HideNegateWarning() end, 12000)
end

function BlockPooky:HideNegateWarning()
    if BlockPooky_negateWarningActive and BlockPooky.negateWarning then
        BlockPooky.negateWarning:SetHidden(true)
        BlockPooky_negateWarningActive = false
    end
end

function BlockPooky:RegisterNegateWarning()
    --d("REGISTER negateWarningLabel")
    if self.config.negate.show then
        EVENT_MANAGER:RegisterForEvent(self.name .. "NegateWarning", EVENT_EFFECT_CHANGED, function(...) self:OnNegateChanged(...) end)
        EVENT_MANAGER:AddFilterForEvent(self.name .. "NegateWarning", EVENT_EFFECT_CHANGED, REGISTER_FILTER_UNIT_TAG, "player")
    end
end

function BlockPooky:UnRegisterNegateWarning()
    if not self.config.negate.show then
        EVENT_MANAGER:UnregisterForEvent(self.name .. "NegateWarning")
    end
end

function BlockPooky:ResetNegateWarningPosition()
    if self.negateWarning:GetAnchor() ~= nil then
        self.negateWarning:ClearAnchors()
    end
    self.negateWarning:SetAnchor(CENTER, GuiRoot, CENTER, 0, -120)
    self:SaveNegateWarningPosition()
end

function BlockPooky:RestoreNegateWarningPosition()
    self:LoadNegateWarningPosition()
end

function BlockPooky:InitNegateWarning()
    if not self.NEGATE_NAMES then
        self.NEGATE_NAMES = {}
        for idx = #self.NEGATE_IDS, 1, -1 do
            --d("negate warning add: " .. self:CleanAbilityName(self.NEGATE_IDS[idx]))
            self.NEGATE_NAMES[self:CleanAbilityName(self.NEGATE_IDS[idx])] = true
        end
    end
    self:CreateNegateWarningLabel()
    self:RegisterNegateWarning()
end


--[[ event handling -------------------------------------------------------------------------------------------------]]

function BlockPooky:OnNegateChanged(
        eventCode, changeType, effectSlot, effectName, unitTag, beginTime, endTime, stackCount, 
        iconName, buffType, effectType, abilityType, statusEffectType, unitName, unitId, abilityId, sourceType)

    local function isNegate(element)
        return BlockPooky.NEGATE_NAMES[element] == true
    end
    --d("UT: " .. unitTag .." changeType: " .. changeType .. "=" .. EFFECT_RESULT_GAINED .. " sourceType: " .. sourceType .. "=" .. BUFF_EFFECT_TYPE_DEBUFF)
    --d(" isNegate: " .. tostring(isNegate(self:CleanupName(effectName))) .. " EN: " .. self:CleanupName(effectName))
    --d(" active? " .. tostring(BlockPooky_negateWarningActive))
    if unitTag == "player" then
        if changeType == EFFECT_RESULT_GAINED -- and sourceType == 5
                and not BlockPooky_negateWarningActive and isNegate(self:CleanupName(effectName)) then
            self:ShowNegateWarning()
        elseif changeType == EFFECT_RESULT_FADED  and BlockPooky_negateWarningActive
                and isNegate(self:CleanupName(effectName)) then
            self:HideNegateWarning()
        end
    end
end
